IF EXISTS (SELECT * FROM sys.objects 
			 WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_AJUSTA_ESEG]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
begin
    drop FUNCTION [dbo].[UFD_EST_AJUSTA_ESEG]
end   
go
  
CREATE FUNCTION [dbo].[UFD_EST_AJUSTA_ESEG](@QT_FACEAMENTO MONEY, @DT_LIMIT_FACEAMENTO DATETIME=null, @QT_FINANCIAMENTO MONEY, @ESEG MONEY) 
RETURNS MONEY with schemabinding 
 AS  
    BEGIN
	    DECLARE @FINAL MONEY
	    DECLARE @AGORA DATE

	    SET @FINAL = @ESEG
	    SET @AGORA=GETDATE()

		IF (@QT_FACEAMENTO > @FINAL) AND @DT_LIMIT_FACEAMENTO >= @AGORA SET @FINAL = @QT_FACEAMENTO
	    IF (@QT_FINANCIAMENTO > @FINAL)	SET @FINAL = @QT_FINANCIAMENTO
		RETURN @FINAL
    END
